/**
 * The contents of this file are subject to the license and copyright
 * detailed in the LICENSE and NOTICE files at the root of the source
 * tree and available online at
 *
 * http://www.dspace.org/license/
 */
package org.dspace.app.util;

import mockit.Mock;
import mockit.MockUp;

/**
 * Mocks the "Util" class, as the getSourceVersion() method in this class
 * is not usable in Unit Testing (since the final JAR is not yet created)
 * @author Tim Donohue
 * 
 */
public class MockUtil extends MockUp<Util>
{
    /**
     * Override/Mock the default "getSourceVersion()" method. This method
     * relies on the "pom.properties" file which is generated by Maven ONLY
     * when building the final dspace-api.jar. During Unit Testing, this
     * "pom.properties" file does NOT exist, which causes a NPE to be thrown.
     * <P>
     * This mocked method simply returns the version as "unit-testing".
     *
     * @return "unit-testing" since this is only used during Unit Tests
     */
    @Mock
    public static String getSourceVersion()
    {
        return "unit-testing";
    }
}
